package org.msh.tb.reports2.me;

import org.msh.reports.datatable.Row;
import org.msh.tb.client.shared.model.CIndicatorResponse;
import org.msh.tb.client.shared.model.CTableColumn;
import org.msh.tb.client.shared.model.CTableRow;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by rmemoria on 8/12/16.
 */
public class TableData {

    private String title;
    private CIndicatorResponse data;
    private String columnTitle;
    private String rowTitle;
    private boolean rowGrouping;
    private Double[] rowTotal;
    private List<List<CTableColumn>> columnsLevels;

    public TableData(String title, CIndicatorResponse data, String columnTitle, String rowTitle,
                     boolean rowGrouping) {
        this.title = title;
        this.data = data;
        this.columnTitle = columnTitle;
        this.rowTitle = rowTitle;
        this.rowGrouping = rowGrouping;
    }

    /**
     * Return the total number of columns including child columns
     * @return
     */
    public int getNumColumns() {
        int num = 0;
        for (CTableColumn col: data.getColumns()) {
            num += col.getSpan();
        }
        return num;
    }

    public List<List<CTableColumn>> getColumnsLevels() {
        if (columnsLevels == null) {
            mountColumnsLevels();
        }
        return columnsLevels;
    }

    /**
     * Mount the list of columns by level
     */
    private void mountColumnsLevels() {
        columnsLevels = new ArrayList<List<CTableColumn>>(data.getColumnLevels());

        // initialize levels
        for (int i = 0; i < data.getColumnLevels(); i++) {
            columnsLevels.add(new ArrayList<CTableColumn>());
        }

        for (CTableColumn col: data.getColumns()) {
            mountLevel(col, 0);
        }
    }

    private void mountLevel(CTableColumn col, int level) {
        List<CTableColumn> cols = columnsLevels.get(level);
        cols.add(col);
        if (col.getColumns() != null) {
            col.setRowSpan(1);
            for (CTableColumn child: col.getColumns()) {
                mountLevel(child, level + 1);
            }
        } else {
            col.setRowSpan(columnsLevels.size() - level);
        }
    }


    /**
     * Return the total number of cases
     * @return
     */
    public double getTotal() {
        double sum = 0;
        for (CTableRow row: data.getRows()) {
            sum += row.getTotal();
        }
        return sum;
    }

    /**
     * Return the total of the rows
     * @return
     */
    public Double[] getRowTotal() {
        if (rowTotal == null) {
            int size = data.getRows().size();
            if (size > 0) {
                rowTotal = new Double[data.getRows().get(0).getValues().length];

                for (CTableRow row: data.getRows()) {
                    if (row.getLevel() == 0) {
                        Double[] vals = row.getValues();
                        for (int i = 0; i < vals.length; i++) {
                            if (vals[i] != null) {
                                double val = rowTotal[i] != null ? rowTotal[i] : 0;
                                rowTotal[i] = val + vals[i];
                            }
                        }
                    }
                }
            }
        }
        return rowTotal;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public CIndicatorResponse getData() {
        return data;
    }

    public void setData(CIndicatorResponse data) {
        this.data = data;
    }

    public String getColumnTitle() {
        return columnTitle;
    }

    public void setColumnTitle(String columnTitle) {
        this.columnTitle = columnTitle;
    }

    public String getRowTitle() {
        return rowTitle;
    }

    public void setRowTitle(String rowTitle) {
        this.rowTitle = rowTitle;
    }

    public boolean isRowGrouping() {
        return rowGrouping;
    }

    public void setRowGrouping(boolean rowGrouping) {
        this.rowGrouping = rowGrouping;
    }
}
